﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="BasicSimulator.aspx.cs" Inherits="LVProSimApp.BasicSimulator" %>

<!DOCTYPE html>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>

    <link rel="Shortcut Icon" href="favicon.ico" type="image/x-icon" />
    <link rel="stylesheet" href="style/BasicSimulator/basicSimulator.bundle.min.css" media="screen, print"/>

    <title>Simulator</title>
</head>

<body>
    <div id="header">
        <div id="menuBar">
            <img id="smallLogo" src="images/logo_festo.png" />
            <div id="fileMenu" class="menuBarElement"><span id="fileMenuText" class="menuText translatableElement"></span>
			    <div id="fileDropDownMenu" class="dropDownMenu">
				    <div id="closeMenuOption" class="dropDownMenuOption" onclick="window.close()"><span id="closeMenuOptionText" class="menuText translatableElement"></span></div>
				</div>
			</div>
            <div id="viewMenu" class="menuBarElement"><span id="viewMenuText" class="menuText translatableElement"></span>
				<div id="viewDropDownMenu" class="dropDownMenu">
                    <div id="displayValuesMenuOption" class="dropDownMenuOption" onclick="toggleBasicSimulatorView()">
                        <span id="displayValuesMenuOptionText" class="menuText translatableElement"></span>
					</div>
                    <hr class="menuBarSpacer" />
					<div id="showSettingsMenuOption" class="dropDownMenuOption selectedMenuBarElement" onclick="showHideSettings('settingsContainer', 'showSettingsMenuOption', 'toggleRightPanelButton')">
                        <span id="showSettingsMenuOptionText" class="menuText translatableElement"></span>
					</div>
				</div>
			</div>
            <div id="helpMenu" class="menuBarElement"><span id="helpMenuText" class="menuText translatableElement"></span>
				<div id="helpDropDownMenu" class="dropDownMenu">
					<div id="contentsIndexMenuOption" class="dropDownMenuOption" onclick="downloadHelpPDF()"><span id="contentsIndexMenuOptionText" class="menuText translatableElement"></span></div>      
				</div>
			</div>
        </div>
        <div id="toolBar">
            <div id="PID1Button" class="toolBarButton translatableElement" onclick="togglePID1Mode()" title="">
                <img class="toolBarImage" src="images/global/PID1.png" /> 
            </div>
            <%--<div class="toolBarSeparator"></div>--%>
            <div id="PID2Button" class="toolBarButton translatableElement" onclick="togglePID2Mode()" title="">
                <img class="toolBarImage" src="images/global/PID2.png" /> 
            </div>
            <div class="toolBarSeparator"></div>
            <div id="cascadeButton" class="toolBarButton translatableElement" onclick="toggleCascadeMode()" title="">
                <img class="toolBarImage" src="images/global/cascade.png" /> 
            </div>
        </div>
    </div>

    <div id="settingsContainer">
        <%-- PROCESS 2 --%>
        <div id="process2Container" class="dynamicsContainer">
            <div id="process2DynamicsTitle" class="dynamicsTitle">
                <span id="process2DynamicsTitleText" class="titleText translatableElement"></span>
            </div>
            <div id="process2OptionsContainer" class="dynamicsOptionsContainer">
                <div id="process2TimeConstant1" class="dynamicsOptions">
                    <span id="process2TimeConstant1Text" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess2TimeConstant1" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process2TimeConstant2" class="dynamicsOptions">
                    <span id="process2TimeConstant2Text" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess2TimeConstant2" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process2Gain" class="dynamicsOptions">
                    <span id="process2GainText" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess2Gain" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process2DeadTime" class="dynamicsOptions">
                    <span id="process2DeadTimeText" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess2DeadTime" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
            </div>
        </div>

        <%-- PROCESS 1 --%>
        <div id="process1Container" class="dynamicsContainer">
            <div id="process1DynamicsTitle" class="dynamicsTitle">
                <span id="process1DynamicsTitleTextNonCascade" class="titleText translatableElement"></span>
            </div>
            <div id="process1OptionsContainer" class="dynamicsOptionsContainer">
                <div id="process1TimeConstant1" class="dynamicsOptions">
                    <span id="process1TimeConstant1Text" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess1TimeConstant1" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process1TimeConstant2" class="dynamicsOptions">
                    <span id="process1TimeConstant2Text" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess1TimeConstant2" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process1Gain" class="dynamicsOptions">
                    <span id="process1GainText" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess1Gain" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
                <div id="process1DeadTime" class="dynamicsOptions">
                    <span id="process1DeadTimeText" class="labelText translatableElement"></span>
                    <input type="text" id="inputProcess1DeadTime" class="inputPositiveFloat inputField dynamicsInputBox"/>
                </div>
            </div>
        </div>

        <%-- DISTURBANCE --%>
        <div class="dynamicsContainer">
            <div id="disturbanceDynamicsTitle" class="dynamicsTitle">
                <span id="disturbanceDynamicsTitleText" class="titleText translatableElement"></span>
            </div>
            <div id="disturbanceOptionsContainer"  class="dynamicsOptionsContainer">
                <div id="disturbanceModeContainer">
                    <input id="buttonAutoMode" onclick="toggleDisturbanceAutomaticMode()" type="button" class="customButton translatableElement" value="" />
                    <input id="buttonManualMode" onclick="toggleDisturbanceManualMode()" type="button" class="customButton translatableElement" value="" />
                </div>
                <div id="disturbanceManualContainer">
                    <div id="disturbanceOutput" class="dynamicsOptions">
                        <span id="disturbanceOutputText" class="labelText translatableElement"></span>
                        <input type="text" id="inputDisturbanceOutput" class="inputPositiveFloat inputField dynamicsInputBox"/>
                    </div>
                </div>
                <div id="disturbanceAutomaticContainer">
                    <div id="disturbanceTimeConstant1" class="dynamicsOptions">
                        <span id="disturbanceTimeConstant1Text" class="labelText translatableElement"></span>
                        <input type="text" id="inputDisturbanceTimeConstant1" class="inputPositiveFloat inputField dynamicsInputBox"/>
                    </div>
                    <div id="disturbanceTimeConstant2" class="dynamicsOptions">
                        <span id="disturbanceTimeConstant2Text" class="labelText translatableElement"></span>
                        <input type="text" id="inputDisturbanceTimeConstant2" class="inputPositiveFloat inputField dynamicsInputBox"/>
                    </div>
                    <div id="disturbanceGain" class="dynamicsOptions">
                        <span id="disturbanceGainText" class="labelText translatableElement"></span>
                        <input type="text" id="inputDisturbanceGain" class="inputPositiveFloat inputField dynamicsInputBox"/>
                    </div>
                    <div id="disturbanceDeadTime" class="dynamicsOptions">
                        <span id="disturbanceDeadTimeText" class="labelText translatableElement"></span>
                        <input type="text" id="inputDisturbanceDeadTime" class="inputPositiveFloat inputField dynamicsInputBox"/>
                    </div>
                    <div id="disturbanceInput" class="dynamicsOptions">
                        <span id="disturbanceInputText" class="labelText translatableElement"></span>
                        <select id="inputDisturbanceInput" class="inputField dynamicsSelectBox"></select>
                    </div>
                </div>
            </div>
        </div>

        <div id="pushButtonContainer">
            <input id="pushButton" type="button" class="customButton translatableElement" onclick="pushSettingsToSimulator()" value="" />
        </div>
    </div>
    <div id="toggleRightPanelButton" class="outerRightPanelButton translatableElement" title="" onclick="showHideSettings('settingsContainer', 'showSettingsMenuOption', 'toggleRightPanelButton')">
        <div class="toggleArrow arrow-right-large"></div>
    </div>

    <div id="mainContainer">
        <div id="SVGContainer">
            <svg id="basicSimulatorSVG" version="1.1" width="700px" height="400px" xmlns="http://www.w3.org/2000/svg" preserveAspectRatio="xMidYMid meet" viewBox="0 0 700 400">
                <rect stroke-linejoin="miter" stroke-dasharray="none" stroke-dashoffset="0" height="89.012" width="156.89" stroke="#4d4d4d" stroke-linecap="butt" stroke-miterlimit="4" y="165.28" x="174.7" stroke-width="0.58313" fill="none"/>

                <rect fill-rule="nonzero" stroke-dashoffset="0" height="63.91" width="98.91" stroke="#000000" stroke-miterlimit="4" y="183.39" x="230.22" fill="#ad9de1"/>
                <rect fill-rule="nonzero" stroke-dashoffset="0" height="63.805" width="130.29" stroke="#000000" stroke-miterlimit="4" y="184.15" x="351.19" stroke-width="0.93638" fill="#b3b3b3"/>
                <path d="m354.53,216.24h63.095,60.637" stroke="#000000" stroke-miterlimit="4" stroke-width="0.911203" fill="#000000"/>
                <text font-size="12px" font-weight="normal" xml:space="preserve" font-style="normal" y="245.241027" x="363.37961" font-family="Sans" fill="#000000"/>
                <path d="m532.95,216.28a15.433,15.433,0,1,1,-30.868,0,15.433,15.433,0,1,1,30.868,0z" fill-rule="nonzero" stroke="#000000" stroke-miterlimit="4" stroke-width="0.699688" fill="#00d059"/>
                <text font-size="27.932272px" font-weight="normal" xml:space="preserve" font-style="normal" y="225.909487" x="508.84601" font-family="Sans" fill="#000000">
                    <tspan y="225.909487" x="508.84601">Σ</tspan>
                </text>
                <path marker-end="none" d="m481.62,216.11h6.3211,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.818216" fill="none"/>
                <path d="m494.21,212.14v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                <path marker-end="none" d="m517.29,161.57v16.349,15.259" stroke="#000000" stroke-miterlimit="4" fill="none"/>
                <path d="m521.26,192.7h-8.2375l4.0672,7.0446,4.1703-7.0446z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                <path d="m190,239.07h8.2375l-4.0672-7.0446-4.1703,7.0446z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>

                <%-- Secondary State 1 --%>
                <path d="m345.64999,308.48001l-151.42999,0l0,-69.923" stroke="#000000" fill="none"/>
                <path d="m517.94,232.28999l0,76.19301l-163.91,0" stroke="#000000" fill="none"/>
                <text id="secondaryState1Error" class="SVGState" y="313" x="348.5" fill="#ff0000">?</text>
                <path id="secondaryState1Ok" class="SVGState" d="m345.64001,308.48001l8.39529,0" stroke="#000000" stroke-width="1.00413" fill="none"/>

                <path d="m209.34,215.57a15.433,15.433,0,1,1,-30.868,0,15.433,15.433,0,1,1,30.868,0z" fill-rule="nonzero" stroke="#000000" stroke-miterlimit="4" stroke-width="0.699688" fill="#00d059"/>
                <text font-size="27.932272px" font-weight="normal" xml:space="preserve" font-style="normal" y="225.202877" x="185.23831" font-family="Sans" fill="#000000">
                    <tspan y="225.202877" x="185.23831">Σ</tspan>
                </text>
                <path marker-end="none" d="m329.81,216h6.3211,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.818216" fill="none"/>
                <path d="m342.39,212.04v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                <path marker-end="none" d="m209.6,216h6.3211,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.818216" fill="none"/>
                <path d="m222.19,212.04v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                <path d="m170.4,211.62v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    
                <%-- PID Controller 1 Text --%>
                <text id="MainPIDText" y="161" x="253">
                    <tspan id="MainTextNonCascade" class="SVGText translatableElement"></tspan>
                    <tspan id="MainPID1" class="SVGText translatableElement PIDIdentifier"></tspan>
                </text>

                <text id="PID1CtrlProportionalLabel" class="SVGText translatableElement" y="199" x="280">PROPORTIONAL</text>
                <text id="PID1CtrlIntegralLabel" class="SVGText translatableElement" y="221" x="280">INTEGRAL</text>
                <text id="PID1CtrlDerivativeLabel" class="SVGText translatableElement" y="243" x="280">DERIVATIVE</text>

                <%-- Process 1 Text --%>
                <text id="process1TextNonCascade" class="SVGText translatableElement" y="180" x="415">Primary Process Dynamics</text>

                <text id="process1GainLabel" class="SVGText SVGTextMode translatableElement" y="205" x="380">GAIN</text>
                <text id="process1DeadTimeLabel" class="SVGText SVGTextMode translatableElement" y="205" x="440">DEAD TIME</text>
                <text id="process1Time1Label" class="SVGText SVGTextMode translatableElement" y="237" x="384">TIME 1</text>
                <text id="process1Time2Label" class="SVGText SVGTextMode translatableElement" y="237" x="448">TIME 2</text>

                <text id="process1EQN1" class="SVGEQN SVGEQNMode" y="213" x="415">
                    <tspan class="base"></tspan>
                    <tspan class="exp" dy ="-8"></tspan>
                </text>
                <text id="process1EQN2" class="SVGEQN SVGEQNMode" y="233" x="415"></text>

                <%-- Process 1 Variable Text --%>
                <text id="process1VariableTextNonCascade" class="SVGText translatableElement" y="303" x="435">Primary Process Variable</text>

                <%-- Disturbance Text  -  Automatic/Manual --%>
                <g class="SVGAutomaticMode">
                    <path id="svg_21" marker-end="none" fill="none" stroke-width="0.81822" stroke-miterlimit="4" stroke="#000000" d="m517.57001,76.112l0,6.3211l0,5.8997"/>
                    <path id="svg_22" fill="#000000" stroke-width="0.94498px" stroke="#000000" d="m521.53003,88.702l-8.23749,0l4.0672,7.04459l4.17029,-7.04459z"/>
                    <rect id="svg_32" fill="#ffdd55" stroke-width="0.93638" x="451.9" y="96.813" stroke-miterlimit="4" stroke="#000000" width="130.29" height="63.805" stroke-dashoffset="0" fill-rule="nonzero"/>
                    <path id="svg_33" fill="#000000" stroke-width="0.9112" stroke-miterlimit="4" stroke="#000000" d="m455.23999,128.89999l63.09497,0l60.63702,0"/>

                    <text id="disturbanceDynamicsAutoLabel" class="SVGText translatableElement" y="89" x="440">Disturbance Dynamics</text>

                    <text id="disturbanceDynamicsGainLabel" class="SVGText SVGTextMode translatableElement" y="120" x="481">GAIN</text>
                    <text id="disturbanceDynamicsDeadTimeLabel" class="SVGText SVGTextMode translatableElement" y="120" x="541">DEAD TIME</text>
                    <text id="disturbanceDynamicsTime1Label" class="SVGText SVGTextMode translatableElement" y="152" x="485">TIME 1</text>
                    <text id="disturbanceDynamicsTime2Label" class="SVGText SVGTextMode translatableElement" y="152" x="549">TIME 2</text>

                    <text id="disturbEQN1" class="SVGEQN SVGEQNMode" y="125" x="517">
                        <tspan class="base"></tspan>
                        <tspan class="exp" dy ="-8"></tspan>
                    </text>
                    <text id="disturbEQN2" class="SVGEQN SVGEQNMode" y="145" x="517"></text>
                </g>
                <g class="SVGManualMode">
                    <path marker-end="none" d="m518,109.43v6.3211,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.818216" fill="none"/>
                    <path d="m521.96,122.02h-8.2375l4.0672,7.0446,4.1703-7.0446z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    <rect fill-rule="nonzero" stroke-dashoffset="0" height="31.048" width="64.296" stroke="#000000" stroke-miterlimit="4" y="130.22" x="484.56" stroke-width="0.45886" fill="#ffdd55"/>

                    <text id="disturbanceDynamicsManualLabel" class="SVGText translatableElement" y="123" x="440">Disturbance Dynamics</text>

                    <text id="outputLabel" class="SVGText SVGTextMode translatableElement" y="151" x="517">OUTPUT</text>

                    <text id="disturbOUTPUT" class="SVGEQN SVGEQNMode" y="151" x="517"></text>
                </g>

                <%-- Process 1 Text  -  Non-Cascade/Cascade --%>
                <g class="SVGNonCascadeMode">
                    <path marker-end="none" d="m157.81,215.59h6.3211,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.818216" fill="none"/>
                </g>
                <g class="SVGCascadeMode">
                    <rect stroke-linejoin="miter" stroke-dasharray="none" stroke-dashoffset="0" height="89.012" width="156.89" stroke="#666666" stroke-linecap="butt" stroke-miterlimit="4" y="165.28" x="3.5771" stroke-width="0.58313" fill="none"/>
                    <rect fill-rule="nonzero" stroke-dashoffset="0" height="63.805" width="130.29" stroke="#000000" stroke-miterlimit="4" y="184.25" x="553.98" stroke-width="0.93638" fill="#b3b3b3"/>
                    <path d="m557.32,216.34h123.73" stroke="#000000" stroke-miterlimit="4" stroke-width="0.91120303" fill="#000000"/>
                    <path style="marker-end:none;" d="m533.31,216.1h12.221" stroke="#000000" stroke-miterlimit="4" stroke-width="0.81821603" fill="none"/>
                    <path d="m545.89,212.14v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    <rect fill-rule="nonzero" stroke-dashoffset="0" height="63.91" width="98.91" stroke="#000000" stroke-miterlimit="4" y="183.14" x="58.829" fill="#ad9de1"/>
                    <path d="m37.949,215.32a15.434,15.434,0,0,1,-30.868,0,15.434,15.434,0,1,1,30.868,0z" fill-rule="nonzero" stroke="#000000" stroke-miterlimit="4" stroke-width="0.69968802" fill="#00d059"/>
                    <text font-family="Sans" xml:space="preserve" font-size="27.93227196px" y="224.94946" x="13.847755" font-weight="normal" font-style="normal" fill="#000000">
                        <tspan y="224.94946" x="13.847755">Σ</tspan>
                    </text>
                    <path style="marker-end:none;" d="m38.209,215.75h12.221" stroke="#000000" stroke-miterlimit="4" stroke-width="0.81821603" fill="none"/>
                    <path d="m50.799,211.79v8.2375l7.0446-4.0672-7.0446-4.1703z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    <path style="marker-end:none;" d="m23.287,179.47,0,6.3211,0,5.8997" stroke="#000000" stroke-miterlimit="4" stroke-width="0.81821603" fill="none"/>
                    <path d="m27.257,192.06-8.2375,0,4.0672,7.0446,4.1703-7.0446z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    <path d="m18.51,238.15h8.2375l-4.0672-7.0446-4.1703,7.0446z" stroke="#000000" stroke-width="0.944978px" fill="#000000"/>
                    
                    <%-- Primary State 1 --%>
                    <path d="m158.22,215.75,2.2181,0" stroke="#000000" stroke-width="1px" fill="none"/>
                    <path d="m167.84,215.75,2.2181,0" stroke="#000000" stroke-width="1px" fill="none"/>
                    <text id="primaryState1Error" class="SVGState" y="220.26839" x="163.81497" fill="#ff0000">?</text>
                    <path id="primaryState1Ok" class="SVGState" d="m159.95,215.75,8.3953,0" stroke="#000000" stroke-width="1" fill="none"/>

                    <%-- Primary State 2 --%>
                    <path d="m345.64999,364.64999l-322.95001,0l0,-125.98001" stroke="#000000" fill="none"/>
                    <path d="m620.15002,248.05l0,116.59999l-266.10999,0" stroke="#000000" fill="none"/>
                    <text id="primaryState2Error" class="SVGState" y="369.24316" x="348.57617" fill="#ff0000">?</text>
                    <path id="primaryState2Ok" class="SVGState" d="m345.64001,364.64001l8.39529,0" stroke="#000000" stroke-width="1" fill="none"/>

                    <%-- PID Controller 2 Text --%>
                    <text id="SecondPIDText" y="161" x="83">
                        <tspan id="SecondTextCascade" class="SVGText translatableElement"></tspan>
                        <tspan id="SecondPID1" class="SVGText translatableElement PIDIdentifier"></tspan>
                    </text>

                    <text id="PID2CtrlProportionalLabel" class="SVGText translatableElement"  y="199" x="108">PROPORTIONAL</text>
                    <text id="PID2CtrlIntegralLabel" class="SVGText translatableElement" y="221" x="108">INTEGRAL</text>
                    <text id="PID2CtrlDerivativeLabel" class="SVGText translatableElement" y="243" x="108">DERIVATIVE</text>

                    <%-- Process 2 Text --%>
                    <text id="process2TextCascade" class="SVGText translatableElement" y="180" x="618">Primary Process Dynamics</text>

                    <text id="process2GainLabel" class="SVGText SVGTextMode translatableElement" y="205" x="583">GAIN</text>
                    <text id="process2DeadTimeLabel" class="SVGText SVGTextMode translatableElement" y="205" x="643">DEAD TIME</text>
                    <text id="process2Time1Label" class="SVGText SVGTextMode translatableElement" y="237" x="587">TIME 1</text>
                    <text id="process2Time2Label" class="SVGText SVGTextMode translatableElement" y="237" x="651">TIME 2</text>

                    <text id="process2EQN1" class="SVGEQN SVGEQNMode" y="213" x="618">
                        <tspan class="base"></tspan>
                        <tspan class="exp" dy ="-8"></tspan>
                    </text>
                    <text id="process2EQN2" class="SVGEQN SVGEQNMode" y="233" x="618"></text>

                    <%-- Process 2 Varible Text --%>
                    <text id="process2VariableTextCascade" class="SVGText translatableElement" y="359" x="535">Primary Process Variable</text>
                </g>
            </svg>
        </div>
    </div>

    <div id="customDialog" title="" class="dialog" style="display:none;">
    </div>
    <%=AddScripts() %> 
</body>
</html>
